
import SwiftUI

struct ContentView: View {
   let list = ["image1", "image2", "image3"]

   var body: some View {
      VStack {
         Text("Hello World!")
            .padding()
         Button("Run Task") {
            Task {
               let stream = AsyncStream { continuation in
                  for (index, image) in list.enumerated() {
                     Task {
                        let time = index * 3
                        try await Task.sleep(for: .seconds(time))
                        continuation.yield(image)
                        
                        if index >= list.count - 1 {
                           continuation.finish()
                        }
                     }
                  }
               }
               for await item in stream {
                  print(item)
               }
            }
         }
      }
   }
}

#Preview {
    ContentView()
}
